-- Create Level
require 'g_level'
g_level.reset()

lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

--Init animation
lua_init_texture("particle", "data/images/particle.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_subtexture_animation("particle",4,4,1,14,MODE_LOOP, DIRECTION_FORWARD,0.075)

lua_init_texture("purple_flame", "data/images/purple_flame.png",FM_NEAREST,WM_CLAMP,WM_CLAMP,AM_MODULATE)
lua_init_subtextures("purple_flame",8,1,1,5) -- using a selfmade lua function to initialize
lua:init_animation("purple_flame",MODE_LOOP, DIRECTION_FORWARD)
lua:animation_add_frame("purple_flame","purple_flame_1", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_2", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_3", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_4", 0.125)
lua:animation_add_frame("purple_flame","purple_flame_5", 0.125)


-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(0.0,0.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(0.2,0.2,BM_DEFAULT) -- 1 = taustavuoret
lua:create_layer(0.4,0.4,BM_DEFAULT) -- 2 = taustamets
lua:create_layer(0.75,0.75,BM_DEFAULT) -- 3 = lhipuita
local parallax_x = 1.0
local parallax_y = 1.0
local kamerapurkka = 1.0;
lua:create_layer(parallax_x,parallax_y,BM_DEFAULT) -- 4
lua:create_layer(parallax_x,parallax_y,BM_DEFAULT) -- 5
lua:create_layer(kamerapurkka , kamerapurkka ,BM_DEFAULT) -- 6 = fysiikka + pelaaja
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 7 = joitain ruoho/kivijuttuja
lua:create_layer(1.1,1.1,BM_DEFAULT) -- 8 = foreground

--Segments start
--first road
lua:create_segment(-2616.626, -59.2459)
lua:add_segment(-616.626, -59.2459)
lua:add_segment(-420.626, -55.2459)
lua:add_segment(-243.626, -34.246)
lua:add_segment(24.374, -46.2459)
lua:add_segment(389.374, -12.2459)
lua:add_segment(466.574, -11.7102)
lua:add_segment(695.574, -48.7102)
lua:add_segment(1008.57, -67.7102)
lua:add_segment(1354.57, -14.7102)
lua:add_segment(1709.63, 32.7025)
lua:add_segment(1882.63, 33.7025)
--road end
--road start
lua:create_segment(2233, 29)
lua:add_segment(2614, -1.99997)
lua:add_segment(2883, 22)
--road end
--road start
lua:create_segment(3191, 128)
lua:add_segment(3392, 135)
--road end
--road start
lua:create_segment(3588, -16)
lua:add_segment(3761, -18)
--road end
--road start
lua:create_segment(4112, 63.9998)
lua:add_segment(4602, 90.9998)
lua:add_segment(5074, 51.9998)
lua:add_segment(5569, 94.9998)
lua:add_segment(6704, 117)
lua:add_segment(7446, 75.9998)
--road end
--road start
lua:create_segment(7680, 203)
lua:add_segment(7892, 199)

lua:create_segment(5948, 1064)
lua:add_segment(6231, 1017)
lua:add_segment(6483, 964)
lua:add_segment(6714, 765)
lua:add_segment(6998, 520)
lua:add_segment(7486, 390)
--road end
--road start
lua:create_segment(5377, 1122)
lua:add_segment(5575, 1127)
--road end
--road start
lua:create_segment(4753, 929)
lua:add_segment(4981, 930)

lua:create_segment(4364, 1043)
lua:add_segment(4556, 1037)

lua:create_segment(2559, 1165)
lua:add_segment(3034, 1158)
lua:add_segment(3388, 1146)
lua:add_segment(3735, 1125)
lua:add_segment(4153, 1065)

lua:create_segment(2592, 1354)
lua:add_segment(2740, 1355)


lua:create_segment(2841, 1510)
lua:add_segment(3010, 1518)

lua:create_segment(3189, 1486)
lua:add_segment(3330, 1483)

lua:create_segment(3447.6, 1644.01)
lua:add_segment(3632.6, 1644.01)

lua:create_segment(2862.6, 1771.01)
lua:add_segment(3027.6, 1771.01)

lua:create_segment(3757.25, 1826.12)
lua:add_segment(3919.25, 1832.12)

lua:create_segment(3437.25, 1965.12)
lua:add_segment(3622.25, 1965.12)

lua:create_segment(3044.75, 1986.89)
lua:add_segment(3237.75, 1983.89)

lua:create_segment(3268.37, 2160.06)
lua:add_segment(3414.37, 2162.06)

lua:create_segment(3643.22, 2328.12)
lua:add_segment(3863.22, 2333.12)

lua:create_segment(3992.73, 2454.45)
lua:add_segment(4398.73, 2522.45)
lua:add_segment(4906, 2532)
lua:add_segment(5415, 2568)
lua:add_segment(5760, 2561)
lua:add_segment(6193, 2566)
lua:add_segment(6642, 2584)

lua:create_segment(6844, 2625)
lua:add_segment(7010, 2626)

lua:create_segment(7182, 2582)
lua:add_segment(7362, 2583)

lua:create_segment(7536, 2622)
lua:add_segment(7739, 2617)

lua:create_segment(7903, 2586)
lua:add_segment(8292, 2584)
lua:add_segment(8738, 2604)
lua:add_segment(9049, 2582)
lua:add_segment(9974, 2577)
--lua:create_segment(-345, -40)
--lua:add_segment(40950, -40)

lua:create_segment(3161, -43) --generic, not really used... though has to be there (hox: this is a FEATURE)
--Segments end  

--Trigger start
--BOX start
--left
lua:create_shape("rectangle",PSC_RECTANGLE,40.0,3000.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","",-700.0,2000.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

--bottom
lua:create_shape("rectangle",PSC_RECTANGLE,7000.0,40.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","",4500.0,-180.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name

--right
lua:create_shape("rectangle",PSC_RECTANGLE,40.0,3000.0) -- name, type, width, height
lua:create_trigger("gate", TT_GATE, "data/scripts/srt_game_over.lua","",9000.0,2000.0) --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("gate", TT_GATE, "rectangle") --name, type, shape_name
lua:trigger_add_group_i_belong_to("gate", TT_GATE, "killer") --name, type, group_name
lua:trigger_add_group_can_use_me("gate", TT_GATE, "player") --name, type, group_name
lua:trigger_upload("gate",0) --name
--BOX end

--Level finished start
lua:create_circle("use", 0, 0, 100.0)
lua:create_trigger("use", TT_USE, "data/scripts/data/scripts/srt_mission_forest_accomplisher.lua", "", 8738, 2674)    --name, type, on_enter_script, on_leave_scipt,x,y
lua:trigger_shape("use", TT_USE, "use")                  --name, type, shape_name
lua:trigger_add_group_can_use_me("use", TT_USE, "player") --name, type, group_name
lua:trigger_add_group_i_belong_to("use", TT_USE, "everything") --name, type, group_name
lua:trigger_upload("use",0) --name
--Level finished end

--name of the next map
--g_levelname = "data/scripts/srt_mission_forest_accomplisher.lua"

--Triggers end

--Player
--INIT PLAYER
lua:do_file("data/scripts/crt_player.lua")
lua:init_camera_binder(-586.0, 8923.0, -160.0, 3207.0) -- left, right, bottom, up
lua:upload_player_to_layer(5)  --index of the layer
lua:creature_translation("player", CPT_PLAYER, -420.626, 155.2459) -- set the player to it's right position
--Player end

--INIT POINT SETTINGS
lua:points_reset(20, 5) --par_time (the time to be aimed for, in seconds), max_combo (maximum amount of bats in the map)
lua:add_point_level("poor",10) -- description of success, points
lua:add_point_level("average",50)
lua:add_point_level("good",80)
lua:add_point_level("perfect",100)
lua:add_point_level("insane",150)
lua:timer_start() --starts the timer for the level HOX: HAS TO BE LAST!!!

lua:set_game_state(GS_PLAY) -- sets the game state to menu. thus you are able to use the menu commands